<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Family Member</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<style>
        body {
            padding: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            font-weight: bold;
        }

        input[type="text"],
        input[type="date"],
        select {
            width: 100%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        input[type="file"] {
            width: 100%;
            padding: 5px;
        }

        .btn-primary {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
    </style>

<body class="container py-4">
    <form action="<?php echo base_url('Family/proses_tambah_family_member'); ?>" method="post" enctype="multipart/form-data" class="p-4 shadow rounded bg-light">
        <h4 class="mb-3 text-center">Tambah Anggota Keluarga</h4>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="name">Nama:</label>
                    <input type="text" class="form-control" id="name" name="name" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="born">Tanggal Lahir:</label>
                    <input type="date" class="form-control" id="born" name="born" required>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="gender">Jenis Kelamin:</label>
                    <select class="form-control" id="gender" name="gender" required>
                        <option value="male">Laki-laki</option>
                        <option value="female">Perempuan</option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="photo">Foto:</label>
                    <input type="file" class="form-control-file" id="photo" name="photo" required>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="email" class="form-control" id="email" name="email">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="phone">Telepon:</label>
                    <input type="tel" class="form-control" id="phone" name="phone" required>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="city">Kecamatan:</label>
                    <input type="text" class="form-control" id="city" name="city" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="country">Kabupaten:</label>
                    <input type="text" class="form-control" id="country" name="country" required>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="fid">Nama Ayah:</label>
                    <select class="form-control" id="fid" name="fid" required>
                        <option value="">--Pilih--</option>
                        <?php foreach ($mother as $m) : ?>
                            <option value="<?= $m['id'] ?>"><?= $m['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="mid">Nama Ibu:</label>
                    <select class="form-control" id="mid" name="mid" required>
                        <option value="">--Pilih--</option>
                        <?php foreach ($pasangan as $p) : ?>
                            <option value="<?= $p['id'] ?>"><?= $p['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <label for="pids">Nama Pasangan:</label>
            <select class="form-control" id="pids" name="pids">
                <option value="">--Pilih--</option>
                <?php foreach ($father as $f) : ?>
                    <option value="<?= $f['id'] ?>"><?= $f['name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <button type="submit" class="btn btn-primary btn-block">Tambah</button>
    </form>
</body>

</html>
