<?php
class Family extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('FamilyModel');
    }

    public function index()
    {
        $data['family_members'] = $this->FamilyModel->get_family_members();
        $this->load->view('family_view', $data);
    }

    public function setting()
    {
        $data['father'] = $this->FamilyModel->get_father();
        $data['mother'] = $this->FamilyModel->get_mother();
        $data['pasangan'] = $this->FamilyModel->get_family_members();
        $this->load->view('setting', $data);
    }

    public function proses_tambah_family_member()
    {
        $this->load->model('FamilyModel');
        $name = $this->input->post('name');

        // Konfigurasi untuk mengunggah gambar
        $config['upload_path'] = 'uploads/';
        $config['allowed_types'] = 'gif|jpg|jpeg|png';
        $config['max_size'] = 5048; // 2MB
        $this->load->library('upload', $config);

        $this->upload->do_upload('image');
        $data = $this->upload->data();
        $path = $_FILES['image']['name'];
        $file_extension = pathinfo($path, PATHINFO_EXTENSION); // Ekstensi file
        // Generate nama file yang baru (direname)
        $new_file_name = $name . '.' . $file_extension; // Anda dapat mengganti "prefix_" sesuai dengan kebutuhan
        // Path lengkap baru (folder path + nama file yang direname)
        $new_file_path = $config['upload_path'] . $new_file_name;
        // Pindahkan file yang diunggah ke path baru
        rename($data['full_path'], $new_file_path);
        // Sekarang, $new_file_path berisi path lengkap file yang direname


        // Simpan informasi gambar dan data lainnya ke dalam database
        $data = array(
            'name' => $this->input->post('name'),
            'born' => $this->input->post('born'),
            'gender' => $this->input->post('gender'),
            'photo' => $new_file_path,
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'city' => $this->input->post('city'),
            'country' => $this->input->post('country'),
            'fid' => $this->input->post('fid'),
            'mid' => $this->input->post('mid'),
            'pids' => $this->input->post('pids')
        );

        $this->FamilyModel->tambah_family_member($data);

        redirect('family');
    }

    public function upload_photo()
    {
        $member_id = $this->input->post('id'); // Ambil ID anggota keluarga yang dikirim

        // Konfigurasi upload file
        $config['upload_path']   = 'uploads/';
        $config['allowed_types'] = 'jpg|jpeg|png';
        $config['max_size']      = 5048;  // 5 MB
        $config['encrypt_name']  = TRUE;  // Menjamin nama file yang unik

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('photo')) {
            $upload_data = $this->upload->data();
            $photo_url = base_url('uploads/' . $upload_data['file_name']);

            // Update path foto di database untuk anggota keluarga dengan ID yang dikirim
            $this->FamilyModel->update_photo($member_id, $photo_url);

            echo json_encode(['status' => 'success', 'photo_url' => $photo_url]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $this->upload->display_errors()]);
        }
    }

    public function save_member_data()
    {
        // Mengambil data dari request POST
        $member_id = $this->input->post('id');
        $name = $this->input->post('name');
        $email = $this->input->post('email');
        $phone = $this->input->post('phone');
        $born = $this->input->post('born');
        $city = $this->input->post('city');
        $country = $this->input->post('country');

        // Menyiapkan data yang akan disimpan
        $data = [
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'born' => $born,
            'city' => $city,
            'country' => $country,
        ];

        // Menyimpan data ke database

        if ($this->FamilyModel->update_family_member($member_id, $data)) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to save data.']);
        }
    }
}
